<!--Copyright 2023 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.

⚠️ Note that this file is in Markdown but contain specific syntax for our doc-builder (similar to MDX) that may not be
rendered properly in your Markdown viewer.

-->

# OFT

[Orthogonal Finetuning (OFT)](https://hf.co/papers/2306.07280) is a method developed for adapting text-to-image
diffusion models. It works by reparameterizing the pretrained weight matrices with it's orthogonal matrix to preserve
information in the pretrained model. To reduce the number of parameters, OFT introduces a block-diagonal structure in
the orthogonal matrix.

The abstract from the paper is:

*Large text-to-image diffusion models have impressive capabilities in generating photorealistic images from text
prompts. How to effectively guide or control these powerful models to perform different downstream tasks becomes an
important open problem. To tackle this challenge, we introduce a principled finetuning method -- Orthogonal Finetuning (
OFT), for adapting text-to-image diffusion models to downstream tasks. Unlike existing methods, OFT can provably
preserve hyperspherical energy which characterizes the pairwise neuron relationship on the unit hypersphere. We find
that this property is crucial for preserving the semantic generation ability of text-to-image diffusion models. To
improve finetuning stability, we further propose Constrained Orthogonal Finetuning (COFT) which imposes an additional
radius constraint to the hypersphere. Specifically, we consider two important finetuning text-to-image tasks:
subject-driven generation where the goal is to generate subject-specific images given a few images of a subject and a
text prompt, and controllable generation where the goal is to enable the model to take in additional control signals. We
empirically show that our OFT framework outperforms existing methods in generation quality and convergence speed*.

## OFTConfig

[[autodoc]] tuners.oft.config.OFTConfig

## OFTModel

[[autodoc]] tuners.oft.model.OFTModel
